%======================================================
%  Matlab demonstration of solving LP dual by the 
%  Alternating Direction Method of Multipliers (ALMM)
%  (beta = 1, block #1: y, block#2: r):
%      minimize      -b'*y
%      subject to     A'*y + r = c, r>=0
%
%      Input: A, b, c,

%
%  Input 
%      A: Sparse constraint left-hand matrix
%      b: constraint right-hand column vector
%      c: objective column vector
%      maxiter: the number of iterations
%  Output: (y,r) of the dual, and -x for the primal 
%
%  Algorithm details can be found in Sect. 14.5
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
function [x,y,r] = ADMMDualLP(A,b,c,maxiter);
if exist('maxiter') ~= 1 
   maxiter=100; 
end
%
[m,n]=size(A);
y=zeros(m,1);
r=c;
x=ones(n,1);
AAT=inv(A*A');
beta=1;
for k=1:100,
% Update y
  bb=b+A*(x-beta*(r-c));
  y=(1/beta)*(AAT*bb);
% Update s
  cc=c-A'*y+(1/beta)*x;
  r=max(0,cc);
% Update multipliers
  x=min(0,x-beta*(A'*y+r-c));
%
end;
x=-x;
%         