%======================================================
%  Matlab demonstration of the diverging example for
%  of the ADMM with three blocks:
%      min   0*x1 + 0*x2 + 0*x3 
%      s.t.    x1 + x2 + x3 =0
%              x1 + x2+2*x3 =0
%              x1+2*x2+2*x3 =0
%
%  Algorithm: Direct extension of multi-block ADMM 
%      
%  Input: any initial solution x0 and multipliers y0
%
%  Output  x: final slution, y: final multipliers
%
%  Problem can be found in Sect. 14.6 and Algorithm in
%  Sect. 14.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%  
function [x, y] = ADMMdiverexm(x0,y0)
%
x=x0;
y=y0;
a1=[1;1;1];
a2=[1;1;2];
a3=[1;2;2];
A=[a1 a2 a3];
history = [];
MAX_ITER = 5e2;
for k=1:MAX_ITER,
  b=-x(2)*a2-x(3)*a3;
  x(1)=a1\(b+y);
  b=-x(1)*a1-x(3)*a3;
  x(2)=a2\(b+y);
  b=-x(1)*a1-x(2)*a2;
  x(3)=a3\(b+y);
  y=y-(A*x);
  history = [history norm(A*x)];
end;
plot(1:k, history(1:k), '-','linewidth',2);
xlabel('Iteration');
ylabel('Absolute Error');
% 