%======================================================
%  Matlab demonstration of the diverging example for
%  of the ADMM with three blocks:
%      min   0*x1 + 0*x2 + 0*x3 
%      s.t.    x1 + x2 + x3 =0
%              x1 + x2+2*x3 =0
%              x1+2*x2+2*x3 =0
%
%  Algorithm: Variable-Spliting of multi-block ADMM 
%      
%  Input: any initial solution x0 and multipliers y0
%         maxiter: the number of iterations
%
%  Output  x: final slution, y: final multipliers
%
%  Details can be found in Example 1 of Sect. 14.6 
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%  
function [x, y] = ADMMvarsplit(x0,y0,maxiter)
if exist('maxiter') ~= 1 
   maxiter=500; 
end
%
x=x0;
u1=x0;
u2=x0;
u3=x0
y=y0;
z1=y0;
z2=y0;
z3=y0;
a1=[1;1;1];
a2=[1;1;2];
a3=[1;2;2];
A=[a1 a2 a3];
history = [];
%
for k=1:maxiter,
  b=u1-z1;
  x(1)=a1\b;
  b=u2-z2;
  x(2)=a2\b;
  b=u3-z3;
  x(3)=a3\b;
  g1=y+z1+x(1)*a1;
  g2=y+z2+x(2)*a2;
  g3=y+z3+x(3)*a3;
  gg=(g1+g2+g3)/4;
  u1=g1-gg;
  u2=g2-gg;
  u3=g3-gg;
  y=y-(u1+u2+u3);
  z1=z1-(u1-x(1)*a1);
  z2=z2-(u2-x(2)*a2);
  z3=z3-(u3-x(3)*a3);
  history = [history norm(A*x)];
end;
plot(1:k, history(1:k), '-','linewidth',2);
xlabel('Iteration: Variable-Splitting Method');
ylabel('Absolute Error');
% 