%======================================================
%  Matlab demonstration of solving quadratic programs
%  the Augmented Lagrangian Method of Multipliers (ALMM)
%  (beta = 1):
%      minimize    0.5x'*Q*x+c'*x
%      subject to    A x = b
%
%  Input 
%      Q: Sparse symmetric objective matrix.
%      A: Sparse constraint left-hand matrix
%      b: constraint right-hand column vector
%      c: objective column vector
%      maxiter: the number of iterations
%
%  Output: decision vars x and multipliers y
%
%  Algorithm details can be found in Sect. 14.4 
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================%
function [x,y] = ALMMeqp(Q,A,b,c,maxiter);
if exist('maxiter') ~= 1 
   maxiter=500; 
end
%
[m,n]=size(A);
y=zeros(m,1);
x=randn(n,1);
for k=1:maxiter,
  r=A'*(b+y)-c;
  x=(Q+A'*A)\r;
  y=y-(A*x-b);
end;
% 