%======================================================
%  Matlab demonstration of the regularized
%  linear regression with 1-norm (LASSO) 
%  regularizations (compressed sensing)
%
%      min   0.5*\|Ax-b\|^2 + mu* sum |s(j)|^{0.5}
%       s.t. x - s = 0   (y)
%
%  Algorithm: ADMM (beta=1), block 1: x, block 2: s
%
%  Input 
%      A: Sparse constraint matrix.
%      b: the right-hand vector
%      x0:initial solution
%      mu: regularization weight
%  Output
%     x  : sparse solution
%  
%  Homework #7.17 and Algorithm in Sect. 14.5 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x]=L2L1regressionADMM(A,b,x0,mu,maxiter)
if exist('mu') ~= 1 
   mu=0.1; 
end
if exist('maxiter') ~= 1 
   maxiter=100; 
end
[m,n]=size(A);
beta=1;
AXINV=inv(A'*A+beta*eye(n));
Ab=A'*b;
%
% set initial solution and multipliers
x=x0;
s=x0;
y=zeros(n,1);
%lambda=1;
iter=0;
while (iter < maxiter),
   iter=iter+1;
   % update x block
   x=AXINV*(Ab+y+s);
   % update s block
   s=zeros(n,1);
   for i=1:n,
       if (x(i)-y(i)-mu)>0,
           s(i)=x(i)-y(i)-mu;
       else if (x(i)-y(i)+mu)<0,
             s(i)=x(i)-y(i)+mu;
           end;
       end;
   end
   % Update multipliers
   y=y - beta*(x-s);
 end;
 x=s;
 % end of the function