%======================================================
%  Matlab demonstration of the regularized
%  linear regression with 0.5-norm 
%  regularizations (compressed sensing)
%
%      min   0.5*\|Ax-b\|^2 + mu* sum |x(j)|^{0.5}
%
%  Algorithm: affine-scaling trust region
%  Input 
%      A: Sparse constraint matrix.
%      b: the right-hand vector
%      x0:initial solution
%      mu: regularization weight
%  Output
%      x    : sparse solution
%      evmin:  the minimal eigen-value of the Hessian
%
%  Homework #7.17 and Algorithm in Sect. 8.5 and 8.7 of
%  L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [xh,evmin]=L2Lxregressiontr(A,b,x0,mu,maxiter)
if exist('mu') ~= 1 
   mu=0.5; 
end
if exist('maxiter') ~= 1 
   maxiter=27; 
end
[m,n]=size(A);
ATA=A'*A;
ee=ones(n,1);
% Compute L2Lhalf solution
x=x0;
lambda=100;
iter=0;
%  Repeatly solving the affine-scalling trust-region step 
while (iter < maxiter),
   iter=iter+1;
   % generate affine-scaled gradient and Hessian and 
   % apply the trust-region method
   dd = abs(x);
   DD = diag(dd);
   gg = dd.*(A'*(A*x-b))+(mu/2)*(sqrt(dd).*sign(x));
   HH = DD*ATA*DD-(mu/4)*diag(sqrt(dd));
   evmin=min(eig(HH))
   if (evmin > 0), evmin=0, end;
   sx = ee -(HH+(abs(evmin)+lambda)*eye(n))\gg;
   x=dd.*sx;
   lambda=lambda/1.5;
end;
xh=x;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% end of the function