% This is a test program to compare the SDM and ADMM
% norm-regularization to recover a regression solution
% in minimizing \|A*x-b\|^2 + mu\sum |x_j|
% 
% Two ways to generate the test problems, each of which 
% has an available feasible to start with.
%
% Use matlab solvers x=L2L1regressionsg(A,b,x0)
%                    x=L2L1regressionADMM(A,b,x0)
%
% Homework #7.17 in Sect. 7.2 and Algorithms in Sect. 8
% and 14.5 of
% L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
% Test Problem Type 1
A=round(sprandn(30,60,.15));
A=[A -A];
% Generate a known sparse solution + or -
xx=round(5*sprandn(120,1,.15));
b=A*xx;
% Generate a dense feasible solution
x0=ones(120,1)+xx;
%
% Test Problem Type 2
%A=sprandn(30,120,.5);
%A=[A -A*ones(120,1)];
%xx=[round(10*sprandn(120,1,.12));0];
%x0=ones(121,1)+xx;
%b=A*x0;
%
% Run the affine-scaling steepest-descent method
% 
x=L2L1regressionSDM(A,b,x0,mu,maxiter);
xSDM=sign(x).*max(abs(x)-1.e-2,0);
%
% Run the ADMM method with
% 
x=L2L1regressionADMM(A,b,x0,mu,maxiter);
xADMM=x;
%
[full(xx) xSDM xADMM]
% 
