% Matlab Demonstration of the second-order interior-point
% primal-dual homotopy or path-following method for solving
% (nonconvex)
%      minimize      0.5*(x(1)+2*x(2)+2)^2
%      subject to    x(1)^2+x(2)^2-1 >= 0; x>=0.
%
%      Input   x0: primal all-ones, s0: dual all-ones
%             eta: reduction rate of mu
%
% Problem/Algorithm can be found in Example 2, Sect. 15.6
% of L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x,s,f,kx] = IPM2ndpathfexam2(x0,s0,eta)
if exist('eta') ~= 1 
   eta=1/2;    
end
%
x=x0;
s=s0;
history = [];
MAX_ITER = 30;
%alpha=0.01;
mu=x'*s/3;
for k=1:MAX_ITER,
  f=x(1)+2*x(2)+2;
  kx=[f-2*x(1)*x(3);2*f-2*x(2)*x(3);x(1)^2+x(2)^2-1];
  Hx=[1 2 -2*x(1);2 4 -2*x(2);2*x(1) 2*x(2) 0];
  [Hx  -eye(3); diag(s)  diag(x)]\[s-kx; mu*ones(3,1)-x.*s];
  dx=ans(1:3);ds=ans(4:6);
  alpha=0.3*abs(min([dx./x;ds./s]));
  x=x+alpha*dx;s=s+alpha*ds;
  %s(1:2)=kx(1:2);
  mu=eta*mu;
  %history = [history x];
end;
% 