%  This matlab implemntation of Primal-Dual IPM method
%  to solve linearly constrained quadratic programs
%
%      min   0.5x'*Hx+c'*x
%      s.t.  Ax <= b, Ae*x = be.
%
%  Input 
%      A: (sparse) inequality constraint matrix.
%      b: inequality right-hand column vector
%      Ae: (sparse) equality constraint matrix.
%      be: equality right-hand column vector
%      toler: Default value: 1.e-6.
%      alpha: step size: 0 < alpha < 1, default value: .8.
%      gamma: barrier reduction rate, default value: 0.5.
%  
%  Output
%     x      : approximate solution,
%     ye     : multipliers of equality constraints
%     s>=0   : slack variables of inequality constraints
%     y>=0   : multipliers of inequality constraints
%             y^Ts =< toler.
%     iter   : number of iterations
%
%   Algorithm detail is in Sect. 13.4 and 15.5
%   L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x,ye,s,y,iter] = PDconvQP(H,c,A,b,Ae,be);
% Set parameters
%
 [m,n] = size(A);
 [me,n] = size(Ae); 
 toler=1.e-6; 
 alpha=0.8;
 gamma=0.5;
%
% Set initial solutions
%
 x = zeros(n,1);
 ye= zeros(me,1);
 ee= ones(m,1);
 s = ee;
 y = ee;
 mu = 1;
 iter =0;
 tic;
%
% Start the loop
%
 while mu >= toler,
   iter = iter + 1;
   %
   % Set up residuals and scaling matrix
   %
   rd= H*x+c+Ae'*ye+A'*y;
   re= Ae*x-be;
   rc= mu./y+A*x-b;
   D = sparse(1:m,1:m,y./s);
   %
   % Newton step
   %
   % Set up scaled matrix and right-hand side
   ATD=A'*D;
   rrr=[-rd-ATD*rc;-re];
   %
   % Solve linear sustem for dx and dye
   dx=[H+ATD*A Ae';Ae sparse(me,me)]\rrr;
   %
   % Construct directions
   dye=dx(n+1:n+me);
   dx=dx(1:n);
   dy=ATD'*dx+D*rc;
   ds=(mu*ee-s.*(y+dy))./y;
%
%  choose step-size
%
   nora = min([dy./y;ds./s]);
   nora = abs(alpha/nora);
%
% Update iterates
%
   x = x + nora*dx;
   ye= ye+ nora*dye;
   s = s + nora*ds;
   y = y + nora*dy;
%
% Duality gap
%
   mu = gamma*max([y'*s/m mu]);
 end;
 time=toc;
%




