% This is the matlab functions for solving the KKT 
% system (infeasible) convex problem
% 
%      min   0.5*(x1+2x2-2)^2
%      s.t.  1- (x1+1)^2+(x2+1)^2 >=0, (x1,x2)>=0.
% 
% Example 1 in Sect. 15.7 of
% L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [f]=mcpfun(x);
% 
[nx,mm]=size(x);
f=zeros(nx,1);
temp=x(1)+2*x(2)-2;
f(1)=temp+2*(x(1)+1)*x(3);
f(2)=2*temp+2*(x(2)+1)*x(3);
f(3)=1-(x(1)+1)^2-(x(2)+1)^2;
return
% 