% This is the matlab functions for solving the KKT 
% system (infeasible) nonconvex problem
% 
%      min   0.5*(x1+2x2-2)^2
%      s.t.  (x1)^2+(x2)^2-1>=0,
%            3*x1+x2 <=0.5, (x1,x2)>=0.
% 
% Related problem/algorithm details in Sect. 15.7 of
% L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [f]=monofun(x);
% 
[nx,mm]=size(x);
f=zeros(nx,1);
temp=x(1)+2*x(2)-2;
f(1)=temp-2*x(1)*x(3)+3*x(4);
f(2)=2*temp-2*x(2)*x(3)+x(4);
f(3)=x(1)^2+x(2)^2-1;
f(4)=-3*x(1)-x(2)+ 0.5;
return
% 