% This is the matlab jacobian matrix for solving the 
% KKT system (feasible) nonconvex problem
% 
%      min   0.5*(x1+2x2-2)^2
%      s.t.  (x1+1)^2+(x2+1)^2-1>=0, (x1,x2)>=0.
% 
% Related problem in Sect. 15.7 of
% L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [G]=jacobian(x);
% 
[nx,mm]=size(x);
G=zeros(nx,nx);
G(1,1)=1+2*x(3);
G(1,2)=2;
G(1,3)=-2*(x(1)+1);
G(2,1)=2;
G(2,2)=4+2*x(3);
G(2,3)=-2*(x(2)+1);
G(3,1)=2*(x(1)+1);
G(3,2)=2*(x(2)+1);
return
% This is the Jacobian of infeasible problem
% in 5th edition
