% Matlab Demonstration of the first-order primal-dual 
% method with epsilon regularization for solving
%
%      minimize      0.5*(x(1)+2*x(2)-1)^2
%      subject to    x(1)^2+x(2)^2-1 = 0;
%
%      Input x0: initial solution in E^2
%            alpha: stepsize
%
%
% Problem/Algorithm can be found in Example 1, Sect. 15.3
% of L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x,kx,Hx] = primaldual1stepexam1(x0,alpha)
if exist('alpha') ~= 1 
   alpha=0.05;    
end
%
x=x0;
history = [];
MAX_ITER = 100;
eps=0.001;
for k=1:MAX_ITER,
  f=x(1)+2*x(2)-2;
  kx=[f-2*x(1)*x(3);2*f-2*x(2)*x(3);x(1)^2+x(2)^2-1]+eps*x;
  Hx=[1-2*x(3) 2 -2*x(1);2 4-2*x(3) -2*x(2);2*x(1) 2*x(2) 0]+eps*eye(3);
  x=x-alpha*kx;
  %history = [history x];
end;
% 