% Matlab Demonstration of the second-order primal-dual 
% homotopy or path-following method for solving
%
%      minimize      0.5*(x(1)+2*x(2)-1)^2
%      subject to    x(1)^2+x(2)^2-1 = 0;
%
%      Input x0: initial solution in E^2
%            eta: reduction rate of mu
%
% Problem/Algorithm can be found in Example 1, Sect. 15.3
% of L&Y, Linear and nonlinear programming, 5th edition
%======================================================% 
function [x,kx,Hx] = primaldual2ndpathexam1(x0,eta)
if exist('eta') ~= 1 
   eta=1/3;    
end
%
x=x0;
history = [];
MAX_ITER = 20;
%alpha=0.01;
mu=10;
for k=1:MAX_ITER,
  f=x(1)+2*x(2)-2;
  kx=[f-2*x(1)*x(3);2*f-2*x(2)*x(3);x(1)^2+x(2)^2-1]+mu*x;
  Hx=[1-2*x(3) 2 -2*x(1);2 4-2*x(3) -2*x(2);2*x(1) 2*x(2) 0]+mu*eye(3);
  dk=Hx\kx;
  x=x-dk;
  mu=eta*mu;
  %history = [history x];
end;
% 